
    # J28 — Deflection SI Overlay (arcsec/meters) — PASS Repo

    This package reproduces the PASS run and lets you re-run the simulation with the exact engine and manifest.

    ## Contents
    - `engine_j28_deflection_overlay.py` — simulation engine (stdlib-only)
    - `manifests/manifest_j28_PASS.json` — PASS manifest (kappa=56, r_deflect_shells=248, b∈[112..88])
    - `scripts/run_pass.py` — convenience runner (creates a new UTC-stamped outdir)
    - `reference_run/2025-11-06T22-59-51Z_adj9_repro/` — full outputs from the PASS run
    - `J28_deflection_overlay/` — will be created on new runs

    ## Requirements
    - Python 3.9+ (standard library only)

    ## Re-run (new timestamped outdir)
    ```bash
    python scripts/run_pass.py
    ```

    Or directly:
    ```bash
    export UTC_TS=$(python - <<'PY'
import datetime as dt;print(dt.datetime.utcnow().strftime('%Y-%m-%dT%H-%M-%SZ'))
PY
)
    python engine_j28_deflection_overlay.py \
  --manifest manifests/manifest_j28_PASS.json \
  --outdir   J28_deflection_overlay/$UTC_TS/
    ```

    ## PASS reference
    - See `reference_run/2025-11-06T22-59-51Z_adj9_repro/outputs/run_info/result_line.txt`
    - Overlay equality & hash invariance in `reference_run/2025-11-06T22-59-51Z_adj9_repro/outputs/audits/j28_audit.json`
